"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/**
 *    Copyright 2016 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

class AuthenticationError extends Error {
  constructor(message, ...params) {
    super(message, ...params);
    this.statusCode = 401;
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, AuthenticationError);
    }
    this.name = this.constructor.name;
    params = params || [];
    const error = params[0];
    if (error instanceof Error) {
      this.inner = error;
    }
  }
}
exports.default = AuthenticationError;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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